

/* model_shape_only.sas  -- 
The initial program ran the creamskimming model for all definitions of contestable volume at various
entrant cost points. Calculated all values based on shape.*/

/* Modified the model_shape_only to make only 1 loop.
Calculated all values based on subclasses- those used to derive the
contestable volumes. The values are for the merged data file (merged1)
based on RMC06 and CCS07;*/

/**************************************************************************************************
* NOTE:  Contestable volumes on routes that cannot be skimmed refers to the fact that there may   *
*  be contestable (available for an entrant to take over) volumes.  However, the entrant does not *
* take them  because they are not profitable                                                      * 
**************************************************************************************************/
/* File based on new computations - new contestable volumes sent on Nov 20, 2008. New Rural wage cost- changed from 32.7 to 31.5-
Change in method from method 2 to 1. Also city file, row on sum has been deleted. City, Rural and merged files used from Rama folder.
Also new cases - Changes in cost advantage.*/


/*Options symbolgen mprint mlogic mcompilenote=all;*/  /* Prints processing
                                                     steps to screen */
***** SET PATH NAME AS APPROPRIATE FOR YOUR COMPUTER;

libname rama 'C:\rama\FinalfilesforPRC';
		

    		/*****************  Macros are identified ************************/

			/*  Macro 1: Creates a field known as skimmed and initializes it */

%macro SetSkimmed(dsin, dsout);

			/* Open the input (dsin) and output (dsout) data file   */

		data &dsout;       	  /* generic out file    */

		set &dsin;       	  /* generic in file     */

        skimmed = 0;  		  /* set flag to zero    */

%mend SetSkimmed;   	     /* end SetSkimmed       */
                                  
/*********************************************************************
*  Macro2: CalcContest  Purpose:  Calculates Contestable Volumes     * 
*  Step 1  Calculates maximum contestable volume.  					 *
*  Step 2  Calculates  Unit Variable Delivery Cost For Entrant		 *
*  Step 3  Calculates USPS volumes from contestable mail classes     *
* 			And profit with no entry								 *
*  Step 4  Calculate Entrants Fixed Delivery Cost      				 *
*  Step 5  Calculate Entrants Total Delivery Cost      				 *
*  Step 6  Assumes entrant takes all contestable volume if profit>0  *
**********************************************************************/

%macro CalcContest(contest, dsin, dsout, cvar, cfixed, skimfactor);  

      			/* For the output file, keep the listed variables and 
				   then compress the file */

		data &dsout (keep=city testid stratum cag rcat
            busdelv resdelv posbus posres totdelv posdelv stops posstops
            c_d3 c_d5 c_d10 c_d16 c_d17 c_d23 cvolume
            cvdc3 cvdc5 cvdc10  cvdc16 cvdc17 cvdc23 cvardc
            cfxd crv_skim cdelcost profit_1 monopoly 
			d3_1 d5_1 d10_1 d16_1 d17_1 d23_1 
			Inc_ProfitAfter Monopoly_Value
  			d2 d3 d4 d5 d7 d8 d10 d16 d17 d23 d24 d25 d28 d29 d41             
			rev2 rev3 rev4 rev5 rev7 rev8 rev10 rev16 rev17 rev23 rev24 rev25 
			rev28 rev29 rev41 
			vdc2 vdc3 vdc4 vdc5 vdc7 vdc8 vdc10 vdc16 vdc17 vdc23 vdc24 vdc25 vdc28 
			vdc29 vdc41 
			ndc2 ndc3 ndc4 ndc5 ndc7 ndc8 ndc10 ndc16 ndc17 ndc23 ndc24 ndc25 
			ndc28 ndc29 ndc41 
			volume vardcost revenue fxddcost delvcost nondcost totcost profit variblty
            wgt rtwgt skimmed compress=y);

        set &dsin; /* open the input file */

        %put CVar: &cvar;     /* is the Entrants % of USPS wage rate    */
        %put CFixed: &cfixed; /* is the same as the Entrants % of USPS wage
		                         rate paid  - passed as a data parameter*/

        if skimmed = 0 then do; /* if flag skimmed = 0 then:            */

			       /* depending on the scenerio run i.e, "1_base" "2_low" etc. 
			       get new contestable volumes for each class of mail and sum 
		           the contestible volumes */
            
        	%GetContestabilityLevel(&contest, &skimfactor);

 				   /*  sum the volumes for First-Class presort ltrs & cards, 
			   		   Periodicals, STD Reg & ECR and Parcel Post           */

        	cvolume = sum(c_d3, c_d5, c_d10, c_d16, c_d17, c_d23); 
		                                                         
                    /*******************************************************************
			      	* Calculate entrant's variable delivery cost times unit variable   *   
		            * delivery cost - unit delivery cost(dollars/piece/ per route).    *
		            * Rama used delivery cost calculated as the sum of piggybacked     *
			        * unit delivery cost for city and piggybacked unit delivery        *
					* cost for rural. Data from Calculations_2007.xls, worksheet       *
			  		* Non-delivery unit attributable, transformed in                   *
			        * Matching_rural_city.xls worksheet buckets_Udeliverycost          *   
					* 0.04288 -  unit variable delivery cost for d3 (given by PRC)     *
					* 0.03736- Unit variable delivery cost for d5 (given by PRC)       *
					* 0.09306 - unit variable delivery costs for d10 (given by PRC)    *
					* 0.06091 -  unit variable delivery cost for d16 (given by PRC)    *
					* 0.05515 - unit variable delivery cost for d17 (given by PRC)     *
					* 0.47284 - unit variable delivery cost for d23 (given by PRC)     *
			        *******************************************************************/

					/* &cvar = the % of USPS wage rate       					  */
					/* Note last term of equation - unit variable cost.  Entrants
			   		unit variable delivery costs for each of the following:    */	
			

            cvdc3 = &cvar*c_d3*0.04288; 	/* First-Class Presort        */
            cvdc5 = &cvar*c_d5*0.03736;		/* First-Class Presort cards  */ 
            cvdc10 = &cvar*c_d10*0.09306;   /* Periodicals				  */
            cvdc16 = &cvar*c_d16*0.06091;	/* Std Reg Carrier Route      */
            cvdc17 = &cvar*c_d17*0.05515;   /* Std Reg                    */  
            cvdc23 = &cvar*c_d23*0.47284;   /* Parcel Post  			  */

            cvardc = sum(cvdc3,cvdc5,cvdc10,cvdc16,cvdc17, cvdc23); /* Sum 
										Entrants variable delivery costs 
										for each of the above mail classes*/

					/* Get the volumes for the classes of that have contestable 
					   volumes on routes that are not profitable */

			d3_1=d3; 		/* First-Class Presort       */
			d5_1=d5;		/* First-Class Presort cards */
			d10_1=d10;		/* Periodicals               */
			d16_1=d16;      /* Standard Regular ECR      */
			d17_1=d17;      /* Standard Regular          */
			d23_1=d23;      /* Parcel Post               */

            profit_1= profit; /* Incumbents profit after skimming is the same as the 
								 initial profit before skimming */

			monopoly=0;       /* Set monopoly value to zero */

			Inc_ProfitAfter=(profit_1*(wgt/10)); /* The increase in USPS profit 
													after skimming multiplied
													by a weight factor divided
													by  10.  The weight comes from the 
													merged1.sas7bdat file */

			Monopoly_Value = (monopoly*(wgt/10)) ; /* The increase in USPS profit 
													after skimming multiplied
													by a weight factor divided
													by  10.  The weight comes from the
													merged1.sas7bdat file */

		end; /* if skimmed = 0 */

			 	/* Calculate entrant's fixed delivery cost.  There are no Fixed
				   Costs for the entrant on Routes with no contestable volume */

            	/* If the contestable volume is greater than zero then entrants total
		       	   fixed costs (cfxd) are the same factor as the Entrants % of USPS wage 
				   rate (assumes that both wage and percent of entrants fixed costs are
				   the same % of USPS wage and fixed costs) Note: cfixed is passed into
				   the macro and fxddcost is  a value stored in merged1.sas7bdat */

			    /* Note:  Entrant does not have a non-delivery cost.  One only needs to 
				   calculate revenues less fixed and variable delivery costs to determine
				   entrants profit.	Fixed Costs for Entrant on Routes with no Contestable
				   Volume Are Zero  */



		if cvolume> 0 then cfxd = &cfixed * fxddcost;

   		else cfxd =0; /* if contestable volumes are not greater than zero then contestable
		                 fixed costs are zero */

					  /* Calculate entrant's  total delivery cost = entrants fixed cost + 
			             entrants variable delivery cost*/
		              /* Note: the entrant does not incur a nondelivery cost, because
						 he is delivering local mail, that has been already dropshipped or
						 presorted by the USPS. The USPS is incurring the nondelivery cost. */

			cdelcost=(cfxd+cvardc);

					  /* if there are no contestable volumes there is no cream skimming */

		 if cvolume = 0 then do;
                	
                skimmed = -1;   /* set skimmed = to negative one */
                crv_skim = 0;   /* there is no cream skimming    */

					 /* sets the contestable volumes on routes that cannot be skimmed 
					  by class of mail = to USPS volumes */

				d3_1=d3;    /* First Class Presort       */
				d5_1=d5;    /* First-Class presort cards */
				d10_1=d10;  /* Periodicals               */ 
				d16_1=d16;  /* Standard Regular ECR      */
				d17_1=d17;  /* Standard Regular          */
				d23_1=d23;  /* Parcel Post               */

         end;

%mend CalcContest; 			/* End macro CalcContest     */

/****************************************************************************************
*  Macro3: CreamSkim  Purpose: Calculate Entrant and USPS Profits & Volumes             *    
*  Step 1.  Calculate USPS volumes of Cntsble Classes with No Entry                     *
*  Step 2.  Calculate USPS volumes, rev, & profits with Entry, & get entrant profit     *
*  Step 3:  Calculate Conditions of USPS after skimming							        *
****************************************************************************************/


%macro CreamSkim(dsin, dsout, discount);

	     	/* output data to be kept and then compress the file */

        data &dsout(keep=city testid stratum cag rcat
              busdelv resdelv posbus posres totdelv posdelv stops posstops
              c_d3 c_d5 c_d10 c_d16 c_d17 c_d23 cvolume
              cvdc3 cvdc5 cvdc10  cvdc16 cvdc17 cvdc23 cvardc
              cfxd crv_skim cdelcost cprofit
		      d3_1 d5_1 d10_1 d16_1 d17_1 d23_1 volume_1           
			  rev3_1 rev5_1 rev10_1 rev16_1 rev17_1 rev23_1  revenue_1
			  vdc3_1 vdc5_1  vdc10_1 vdc16_1 vdc17_1 vdc23_1  vardcost_1
			  ndc3_1 ndc5_1 ndc10_1 ndc16_1 ndc17_1 ndc23_1 nondcost_1 
			  delvcost_1 nondcost_1 totcost_1 variblty_1  
			  d2 d3 d4 d5 d7 d8 d10 d16 d17 d23 d24 d25 d28 d29 d41             
			  rev2 rev3 rev4 rev5 rev7 rev8 rev10 rev16 rev17 rev23 rev24 rev25
              rev28 rev29 rev41 
              vdc2 vdc3 vdc4 vdc5 vdc7 vdc8 vdc10 vdc16 vdc17 vdc23 vdc24 vdc25
              vdc28 vdc29 vdc41 
              ndc2 ndc3 ndc4 ndc5 ndc7 ndc8 ndc10 ndc16 ndc17 ndc23 ndc24 ndc25
              ndc28 ndc29 ndc41 
			  volume vardcost revenue fxddcost delvcost nondcost totcost variblty
              wgt rtwgt skimmed profit profit_1 monopoly Inc_ProfitAfter Monopoly_Value
              loss_volume compress=y);

        set &dsin; 					/* open input file */
   

/**************************************************************************************
* Step 1.  This section introduces the variable associated with the incumbant and     *
*		   calculates his costs, revenues and profits, etc.                           *
**************************************************************************************/ 

 
       if (skimmed = 0) then do;   /* if flag is set to zero */
				
	   			/*************************************************************************
				* Revenue per piece times discounted volume for each class (from         *
				*  Calculations 2007.xls, worksheet Revenue per piece, transformed       * 
				*   in Matching_rural_city.xls, worksheet buckets_URevenue.              *
				*   Originally from "Calculation of Revenue & Non-Delivery               *
		        *   Cost per piece by Subclass", Docket No. ACR2007-1,                   *
		        *   Library Reference PRC-ACR2007-LR1, Filename: 07 Revenue_Fees_LR1.xls,*
		        *   Worksheet "All_R".                                                   *
		        *   0.33026 - unit revenue per route for d3 (given by PRC)               *
				* 0.19827 - unit revenue per route for d5 (given by PRC)                 *
				* 0.24875 - unit revenue per route for d10 (given by PRC)                *
				* 0.17428 - unit revenue per route for d16 (given by PRC)                *
				* 0.21418 - unit revenue per route for d17 (given by PRC)                *
				* 3.46544 - unit revenue per route for d23 (given by PRC);               *
				*************************************************************************/

                
            crv_skim = ((c_d3* (1-&discount) * 0.33026)  +  /* First-Class presort       */
						(c_d5 *(1-&discount) * 0.19827)  +  /* First-Class presort cards */
						(c_d10 * (1-&discount) * 0.24875)+  /* Periodicals               */
						(c_d16* (1-&discount) * 0.17428) +  /* Standard Regular CR       */
						(c_d17 * (1-&discount) * 0.21418)+  /* Standard Regular          */
						(c_d23 * (1-&discount) * 3.46544)); /* Parcel Post               */

					/* sets the contestable volumes on routes that cannot be skimmed 
					   by class of mail = to USPS volumes */

			d3_1=d3;    /* First-Class presort       */
			d5_1=d5;    /* First Class Presort cards */
			d10_1=d10;  /* Periodicals               */
			d16_1=d16;  /* Standard Regular CR       */
			d17_1=d17;  /* Standard Regular          */
			d23_1=d23;  /* Parcel Post               */

			profit_1= profit;  /* Incumbents profit after skimming 
								  is the same as the initial profit
			                      before skimming */

			monopoly=0;        /* Initialize monopoly variable */

			Inc_ProfitAfter=(profit_1*(wgt/10));  /* The increase in USPS profit 
													after skimming multiplied
													by a weight factor divided
													by  10.  The weight comes
													from the merged1.sas7bdat
													file */

   			Monopoly_Value = (monopoly*(wgt/10)) ;  /* The increase in USPS profit 
													after skimming multiplied
													by a weight factor divided
													by  10.  The weight comes from
													the merged1.sas7bdat file. However,
													monoploy = 0 so the value will be 
			                                        zero */

       end; /* end if skimmed */

/******************************************************************************************************
*  Revenue per piece by class from Calculations in 2007.xls,                                          *
* worksheet Revenue per piece, transformed in Matching_rural_city.xls worksheet buckets_URevenue      *                            *
* originally from "Calculation of Revenue and Non-Delivery Cost per piece by Subclass",               * 
* Docket No. ACR2007-1, Library Reference PRC-ACR2007-LR1, 07 Revenue_Fees_LR1.xls, Worksheet "All_R" *
* VERIFIED   Unit Revenue below in PRC-ACR2007-LR1  												  *
* Unit Revenue Per Route Per piece by class                                                           *
* d3= First-Class Workshared Letters, Flats and Parcels = 0.33026                                     *
* d5= First Class Worksshared Cards  = 0.19827                                                        *     
* d10= Total Periodicals	         = 0.24875                                                        *
* d16= Standard Regular & nonprofit  = 0.17428                                                        *
* d17= Standard ECR & Nonprofit ECR  = 0.21418                                                        *
* d23= Parcel Post Mkt Dominant & Competitive Parcel Post = 3.46544                                   *
******************************************************************************************************/

/***************************************************************************************************
*     Step 2.  Calculate new USPS volumes, revenues, profits with Entry.  Also Get Entrants Profit *
***************************************************************************************************/

		if (crv_skim > cdelcost) then do;        /* If Total revenue of entrant is greater than
		                                            Total delivery cost of entrant then */
              skimmed = 1;  	                 /* set flag to 1                       */

					/*****************************************************************************
			  		* USPS volumes from Contestible classes                                      *
                    * Max is a function requiring at least 2 arguments.  It returns the higher   * 
                    *  of the two values and thus is setting the contestable volumes on routes   *
			        *  that are not profitable to skim to the higher of the two volume values    *
			        *  (the "-" sign is a subtraction sign.  Assume that d3=6 and c_d3 = 1 then  *
			        *  d3_1= Max((6-1), 0)) = Max(5,0)=5.  If the subtraction results in a       *
			        *  negative value such as -3, then d3_1= Max (-3,0) = 0.                     *                                          
			        *****************************************************************************/

               d3_1=Max(d3-c_d3,0);      /* Volume of First-Class presort, volume entrant provides */
               d5_1=Max(d5-c_d5,0);      /* Volume of First-Class SP cards, volume entrant provides*/
			   d10_1=Max(d10-c_d10,0);   /* Volume of Periodicals, volume entrant provides         */
			   d16_1=Max(d16-c_d16,0);   /* Volume of Standard Regular ECR, volume entrant provides*/
			   d17_1=Max(d17-c_d17,0);   /* Volume of Standard Regular, volume entrant provides    */
			   d23_1=Max(d23-c_d23,0);   /* Volume of Parcel Post, volume entrant provides         */

             		

               cprofit= crv_skim - cdelcost; /*Calculate entrant's profit*/

        end;   /* if crv_skim > cdelcost */

			   /***********************************************************************
				*   Calculate USPSs new volume                                        *
				**********************************************************************/

	   	volume_1= sum(d2,      /* Volume of First Class                      */
					  d3_1,    /* Contestable volume of First-Class presort  */
					  d4,      /* Volume of First-Class SP cards             */
                      d5_1,    /* Contestable volume of First-Class SP cards */
                      d7,      /* Volume of Priority                         */
                      d8,      /* Volume of Express                          */
                      d10_1,   /* Contestable volume of Periodicals          */
                      d16_1,   /* Contestable volume of STD REG ECR          */
                      d17_1,   /* Contestable volume of STD REG              */
                      d23_1,   /* Contestable volume of Parcel Post          */
					  d24,     /* Volume of Bound Printed Matter             */
                      d25,     /* Volume of Media & Library Mail             */
                      d28,     /* Volume of the USPS                         */
                      d29,     /* Volume of Free for the blind - Free mail   */
                      d41);    /* Volume of Total international mail         */

				/*****************************************************************************
	 			* Calculate incumbent's new revenue by multiplying  new volume times         *
			    *  unit revenues for each subclass as given by the PRC.  Unit revenue is the *
			    *  same for the entrant and the incumbent                          	         *
                *****************************************************************************/

        rev3_1=d3_1*0.33026;
        rev5_1=d5_1*0.19827;
        rev10_1=d10_1*0.24875;
        rev16_1= d16_1*0.17428;
        rev17_1= d17_1*0.21418;
        rev23_1=d23_1*3.46544;
   
		revenue_1= sum(rev2,rev3_1,rev4,rev5_1,rev7,rev8,rev10_1,
				   rev16_1,rev17_1,rev23_1,rev24,rev25,rev28,rev29,rev41);
		
                /*********************************************************************
	 			* Calculate incumbent's new total variable delivery cost             *
      			* Hard coded values are the total unit attributable delivery cost 	 *
      			* from File name: Calculations 2007.xls; Worksheet: Non delivery     *
      			*   unit attributable   	                                         *
				*********************************************************************/
 
         vdc3_1 = d3_1*0.04288; 
         vdc5_1 = d5_1*0.03736;
         vdc10_1 = d10_1*0.09306;
         vdc16_1 = d16_1*0.06091;
         vdc17_1 = d17_1*0.05515;
         vdc23_1 = d23_1*0.47284;

 				/************************************************************************
     			*  vardcost_1 = The total new variable delivery cost for the incumbant  *
		 		*  which the is the sum the total variable delivery costs for the       *
		        *  contestable subclasses (New volume time unit delivery cost for the   *
		        *  subclass as provided by the PRC.  The unit variable delivery cost is *
                * is the same for the entrant and the incumbent                         *		 
		        ************************************************************************/

		vardcost_1 = sum(vdc2,vdc3_1,vdc4,vdc5_1,vdc7,vdc8,vdc10_1,
					 vdc16_1,vdc17_1,vdc23_1,vdc24,vdc25,vdc28,vdc29,vdc41);

				/***********************************************************************
	 			* Calculate new non-delivery costs for incumbant after entrant has     *
				*  skimmed. Hard coded values are the total unit non-delivery cost per *
				*  piece FY 2007 from File name: RMC06_Support.xls ;                   *
				*  Worksheet: Unit Rev & Cost                                          *
				* 0.07532 -  unit non delivery cost for d3 (given by PRC)              *
				* 0.04026- Unit non delivery cost for d5 (given by PRC)                *
				* 0.20661 - unit non delivery costs for d10 (given by PRC)             *
				* 0.03058 -  unit non delivery cost for d16 (given by PRC)             *
				* 0.08997 - unit non delivery cost for d17 (given by PRC)              *
				* 2.88022 - unit non delivery cost for d23 (given by PRC);             *
				***********************************************************************/

    
        ndc3_1=d3_1*0.07532;
        ndc5_1=d5_1*0.04026;
        ndc10_1=d10_1*0.20661;
        ndc16_1=d16_1*0.03058;
        ndc17_1=d17_1*0.08997;
        ndc23_1=d23_1*2.88022;

				/* Sum the total non-delivery costs  including those for *
				 * noncontestable volumes that are not of interest to    *
				 * the entrant        								     */			 

		nondcost_1= sum(ndc2,ndc3_1,ndc4,ndc5_1,ndc7,ndc8,ndc10_1,
					ndc16_1,ndc17_1,ndc23_1,ndc24,ndc25,ndc28,ndc29,ndc41);

				/*************************************************************************	
				 * Calculate incumbent's new total delivery cost which is the sum the    *
				 * fixed delivery cost (fxddcost), which comes from the merged1.sas7bdat *
				 * file, plus the sum of the total new variable delivery costs           *
				 ************************************************************************/

		delvcost_1= fxddcost+ vardcost_1;

				/* Calculate incumbent's new total cost which is the new delivery cost  *
				 * plus the new non-delivery cost after entrant has skimmed             */

		totcost_1= delvcost_1+ nondcost_1;

				/* Calculate incumbent's new profit which is new incumbants revenue less *
		         * incumbants new total cost                                             */

		profit_1= revenue_1-totcost_1;

				/* Calculate the value of the monopoly which is incumbants profit before
				   skimming less incumbants profit after skimming */

		monopoly= profit- profit_1;

				/* Calculate the new variability factor for the incumbent,              *
				 * after skimming, by dividing the new variable delivery costs divided  *
		         * by the total new delivery costs (variable plus fixed)               */

		variblty_1 = vardcost_1 / delvcost_1;

				/*Calculate incumbent's loss in volume*/

		loss_volume= volume-volume_1;

				/* Calculate incumbent's new markup needed in average price. *
				 * markup= (revenue_1/ volume_1)- (revenue/volume)          */

  		Inc_ProfitAfter=(profit_1*(wgt/10));

   		Monopoly_Value = (monopoly*(wgt/10)) ;

run;
                /* Code commented out         */
				/*proc means data= &dsout SUM; 
				VAR Inc_ProfitAfter Monopoly_Value;
				RUN;*/

%mend CreamSkim;

%macro GetSum(contest, tbl, cvar, cfixed, discount, skimfactor, wagefactor); 

/************************************************************************************
* This macro is passed the contestibility case (i.e. 1_Base), the data file         *
* the system evaluation of the &wagefactor, the                                    	*
* system evaluation of the number of days entrant will deliver mail (i.e. 2) divided* 
* by the maximum delivery days (i.e. 6) and the result is then multiplied by the 	*
* wagefactor (i.e. .2, .4, etc. OR (2 divided by 6)times the %wagefactor), the      *
* discount off of the postage rate, the skimfactor and the wagefactor               *
* (i.e., .2, .4, .6, .8, or 1)                                                     	*
************************************************************************************/ 

/* ************************************************************************************
* The following procedure creates a table using data from mail.sum_allcases_discount0 *
*  and will insert into the table the number of days the entrant operates   		  *
*  the dicount level, the contestibility value, the skimFactor, the wagefactor.       *
*  Subsequently, it evaluates data to see if the skimfactor is greater than zero, 	  *
*  if so, the program calculates additional variable values.						  *
*  values for new-variables in the table.											  *
**************************************************************************************/
proc sql;
		INSERT INTO rama.sum_mm_100pct /*Change path here*/

            SELECT

				&j as Days,
				&discount as Discount,
                &contest as Contest,
                &skimfactor as SkimFactor, 
                &wagefactor as WageFactor,
                         
                (select count(*)from &tbl where skimmed>0) as SkimmedObs,
                (select sum(rtwgt) from &tbl where skimmed>0) as SkimmedRts,
                &cvar as VDCFactor,
                &cfixed as FDCFactor, 
                (select Sum (cvolume*(wgt/10))from &tbl where skimmed>0) as Ent_Volume,
          
                (select Sum(c_d3* (wgt/10)) from &tbl where skimmed>0)as Ent_FCPresortLetters,
                (select Sum(c_d5*(wgt/10)) from &tbl where skimmed>0) as Ent_FCPresortCards,
                (select Sum(c_d10*(wgt/10))from &tbl where skimmed>0) as Ent_Periodicals,
                (select Sum(c_d16*(wgt/10))from &tbl where skimmed>0) as Ent_StandCR,
                (select Sum(c_d17*(wgt/10))from &tbl where skimmed>0) as Ent_StandRegular,
                (select Sum(c_d23*(wgt/10))from &tbl where skimmed>0) as Ent_ParcelPost,

                (select Sum(cvardc*(wgt/10)) from &tbl where skimmed>0) as Ent_VarDlvCost,
                (select Sum(cfxd*(wgt/10)) from &tbl where skimmed>0) as Ent_FxdDlvCost,
                (select Sum(cdelcost*(wgt/10)) from &tbl where skimmed>0) as Ent_DelvCost,
                (select Sum(crv_skim*(wgt/10)) from &tbl where skimmed>0) as Ent_Revenue,
                (select Sum(cprofit*(wgt/10)) from &tbl where skimmed>0) as Ent_Profit,

				(select sum(rtwgt)from &tbl where volume>0) as Inc_RoutesServed,

                (Sum(volume*(wgt/10))) as Inc_Volume,
				(Sum(revenue*(wgt/10))) as Inc_Revenue,
				(Sum(vardcost*(wgt/10))) as Inc_VarDlvCost,
				(Sum(fxddcost*(wgt/10))) as Inc_FxdDlvCost,
			    (Sum(delvcost*(wgt/10))) as Inc_DelvCost,
				(Sum(nondcost *(wgt/10))) as Inc_NonDelvCost,
				(Sum(totcost*(wgt/10))) as Inc_TotalCost,
				(Sum(profit*(wgt/10))) as Inc_Profit,
           
               
				(Sum(d3* (wgt/10))) as Inc_FCPresortLetters,
                (Sum(d5*(wgt/10))) as Inc_FCPresortCards,
                (Sum(d10*(wgt/10))) as Inc_Periodicals,
                (Sum(d16*(wgt/10))) as Inc_StandCR,
                (Sum(d17*(wgt/10))) as Inc_StandRegular,
                (Sum(d23*(wgt/10))) as Inc_ParcelPost,

             	(Sum(d3_1* (wgt/10))) as Inc_FCPresortLettersAfter,
                (Sum(d5_1*(wgt/10))) as Inc_FCPresortCardsAfter,
                (Sum(d10_1*(wgt/10))) as Inc_PeriodicalsAfter,
                (Sum(d16_1*(wgt/10))) as Inc_StandCRAfter,
                (Sum(d17_1*(wgt/10))) as Inc_StandRegularAfter,
                (Sum(d23_1*(wgt/10))) as Inc_ParcelPostAfter,

                (Sum(volume_1*(wgt/10))) as Inc_VolumeAfter,
                (Sum(revenue_1*(wgt/10))) as Inc_RevenueAfter,
                (Sum(vardcost_1*(wgt/10))) as Inc_VarDlvCostAfter,
                (Sum(delvcost_1*(wgt/10))) as Inc_DelvCostAfter,
                (Sum(nondcost_1*(wgt/10))) as Inc_NonDelvCostAfter,
                (Sum(totcost_1*(wgt/10))) as Inc_TotalCostAfter,
                (Sum(Inc_ProfitAfter))as Inc_ProfitAfter,
                (Sum(Monopoly_Value)) as Monopoly_Value,
				(Sum(loss_volume*(wgt/10))) as IncVolume_Loss
              
                FROM &tbl;
    quit;

%mend GetSum;

%macro CreateSumTable();


/* This macro creates a table of summary statistics */



    			/*create table for summary statistics*/

		proc sql;
           create table rama.sum_mm_100pct /*Change path here*/
				(Days num,
				Discount num,
                Contest char(10),
                SkimFactor num,
                WageFactor num,
                SkimmedObs num format=12.2,
                SkimmedRts num format=12.2,
                VDCFactor num,
                FDCFactor num,
                Ent_Volume num format=12.2,
 				Ent_FCPresortLetters num format=12.2,
				Ent_FCPresortCards num format=12.2,
				Ent_Periodicals num format=12.2,
				Ent_StandCR num format=12.2,
				Ent_StandRegular num format=12.2,
				Ent_ParcelPost num format=12.2, 
                Ent_VarDlvCost num,
                Ent_FxdDlvCost num,
                Ent_DelvCost num,
                Ent_Revenue num,
				Ent_Profit num,
         
                Inc_RoutesServed num,
				Inc_Volume num format=12.2,
				Inc_Revenue num,
                Inc_VarDlvCost num,
                Inc_FxdDlvCost num,
                Inc_DelvCost num,
                Inc_NonDelvCost num,
				Inc_TotalCost num,
                Inc_Profit num,
                
				Inc_FCPresortLetters num format=12.2,
				Inc_FCPresortCards num format=12.2,
				Inc_Periodicals num format=12.2,
				Inc_StandCR num format=12.2,
				Inc_StandRegular num format=12.2,
				Inc_ParcelPost num format=12.2, 

             
				Inc_FCPresortLettersAfter num format=12.2,
				Inc_FCPresortCardsAfter num format=12.2,
				Inc_PeriodicalsAfter num format=12.2,
				Inc_StandCRAfter num format=12.2,
				Inc_StandRegularAfter num format=12.2,
				Inc_ParcelPostAfter num format=12.2,
                Inc_VolumeAfter num format=12.2, 
                Inc_RevenueAfter num,
                Inc_VarDlvCostAfter num,
                Inc_DelvCostAfter num,
                Inc_NonDelvCostAfter num,
				Inc_TotalCostAfter num,
                Inc_ProfitAfter num,
	            
			Monopoly_Value num,

    		IncVolume_Loss num);

        quit;

%mend CreateSumTable;

%macro ExportDS(ds, file);

/**************************************************************************
* This macro is exports the new table to an Excel Spreadsheet.  The path  *
* for placing the Excel spreadsheet is specified when the macro is called *
* the Excel output file is called: sum_allcases_discount0.xls             *
**************************************************************************/

        proc export data= &ds
            outfile= &file dbms=Excel2000 replace;
        run;

%mend ExportDS;

%macro RunPrg(contest, discount, skimfactor, daysstart, daysend, wagefactor); 
				/*contestable level, entrants price discount, delivery days, cost
                  advantage */

    	%do j=&daysstart %to &daysend %by 1;  /* j is the nr of delivery days less  *
											   * daysstart and daysend and runs the *
				   							   * scenario for each nr of days between* 
											   * the numbers specified */

        	%let cvar=%sysevalf(&wagefactor);
        	%let cfixed=%sysevalf((&j/6)*&wagefactor);


        	%CalcContest(&contest, rama.merged_sum_mm_100pct, rama.skim_sum_mm_100pct,
						 %sysevalf(&cvar), %sysevalf(&cfixed), %sysevalf(&skimfactor));  

			%CreamSkim(rama.skim_sum_mm_100pct, rama.skim_sum_mm_100pct, &discount); 

			%GetSum(&contest, rama.skim_sum_mm_100pct, %sysevalf(&cvar), %sysevalf(&cfixed),
				    &discount, &skimfactor, &wagefactor);

		%end;

%mend RunPrg;
    /***********END MACROS***************************************/

	%include  'c:\rama\FinalfilesforPRC\contest_vol_mailboxmonopoly.sas'; /*contestability level macro*/ /*Change path here*/

    %CreateSumTable;

	%SetSkimmed(rama.merged1, rama.merged_sum_mm_100pct); /*Change path here*/

	%RunPrg("4_no_box", 0, 1, 1, 6, .7);
    %RunPrg("4_no_box", 0, 1, 1, 6, .8);
    %RunPrg("4_no_box", 0, 1, 1, 6, .9);
	%RunPrg("4_no_box", 0, 1, 1, 6, 1);
    
	%RunPrg("4_no_box", 0.05, 1, 1, 6, .7);
    %RunPrg("4_no_box", 0.05, 1, 1, 6, .8);
    %RunPrg("4_no_box", 0.05, 1, 1, 6, .9);
	%RunPrg("4_no_box", 0.05, 1, 1, 6, 1);

	%RunPrg("4_no_box", 0.10, 1, 1, 6, .7);
    %RunPrg("4_no_box", 0.10, 1, 1, 6, .8);
    %RunPrg("4_no_box", 0.10, 1, 1, 6, .9);
	%RunPrg("4_no_box", 0.10, 1, 1, 6, 1);


    %RunPrg("4_no_box", 0.15, 1, 1, 6, .7);
    %RunPrg("4_no_box", 0.15, 1, 1, 6, .8);
    %RunPrg("4_no_box", 0.15, 1, 1, 6, .9);
	%RunPrg("4_no_box", 0.15, 1, 1, 6, 1);

	%RunPrg("4_no_box", 0.20, 1, 1, 6, .7);
    %RunPrg("4_no_box", 0.20, 1, 1, 6, .8);
    %RunPrg("4_no_box", 0.20, 1, 1, 6, .9);
	%RunPrg("4_no_box", 0.20, 1, 1, 6, 1);


    %ExportDS(rama.sum_mm_100pct, "c:\rama\FinalfilesforPRC\sum_mm_100pct.xls"); /*Change path here*/


   		/*  contest_vol_subclass.sas - code sets level of contestability for program.
			Includes subclass factors, as calculated in ContestabilityLevels_2007.xls. */




